/*
 * Decompiled with CFR 0.152.
 */
package com.bonrix.voice;

import com.bonrix.voice.Container;
import com.bonrix.voice.Util;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class EventManager
implements SipListener {
    public static final String PEERS_URL = "http://peers.sourceforge.net/";
    public static final String PEERS_USER_MANUAL = "http://peers.sourceforge.net/user_manual";
    private UserAgent userAgent;
    private boolean closed;
    private net.sourceforge.peers.Logger logger;
    Date calledTimeStamp;
    Date callPickTimeStamp;
    Date callDisconnectTimeStamp;
    SipRequest sipRequest;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    ScheduledFuture<?> taskHandle;
    Runnable callDisconnectTask;

    public EventManager(String peersHome, net.sourceforge.peers.Logger logger, AbstractSoundManager soundManager) {
        this.logger = logger;
        try {
            this.calledTimeStamp = new SimpleDateFormat("yyyyMMddHHmmss").parse("19000101000000");
        }
        catch (ParseException ex) {
            Logger.getLogger(EventManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.closed = false;
        try {
            this.userAgent = new UserAgent((SipListener)this, peersHome, logger, soundManager);
            this.userAgent.getConfig().setMediaFile(Container.bonrixConfig.getAudioFilePath());
            if (this.userAgent.getConfig().isRegistrationRequired()) {
                this.register();
            } else {
                this.registerSuccessful(null);
            }
        }
        catch (SocketException e) {
            System.out.println("Peers sip port unavailable, about to leave. Error");
            Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, logger, null);
        }
    }

    @Override
    public void registering(SipRequest sipRequest) {
        System.out.println("Registering...");
    }

    @Override
    public void registerFailed(SipResponse sipResponse) {
        System.out.println("Register failed...");
        Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, this.logger, null);
    }

    @Override
    public void registerSuccessful(SipResponse sipResponse) {
        System.out.println("Register successful...");
        if (this.closed) {
            this.userAgent.close();
            System.exit(0);
            return;
        }
        this.makeACall();
    }

    @Override
    public void calleePickup(SipResponse sipResponse) {
        System.out.println("Callee pickup...");
        this.callPickTimeStamp = new Date();
        this.callDisconnectTask = new Runnable(){

            @Override
            public void run() {
                EventManager.this.disconnectCallApiAndExit();
            }
        };
        this.taskHandle = this.scheduler.schedule(this.callDisconnectTask, (long)Container.bonrixConfig.getAudioFileDuration(), TimeUnit.SECONDS);
    }

    @Override
    public void error(SipResponse sipResponse) {
        System.out.println("Error..." + sipResponse.toString());
        Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, this.logger, null);
    }

    @Override
    public void incomingCall(SipRequest sipRequest, SipResponse provResponse) {
    }

    @Override
    public void remoteHangup(SipRequest sipRequest) {
        System.out.println("Remote hangup...");
        this.callDisconnectTimeStamp = new Date();
        if (this.taskHandle != null) {
            this.taskHandle.cancel(false);
        }
        int callDuration = (int)((this.callDisconnectTimeStamp.getTime() - this.callPickTimeStamp.getTime()) / 1000L);
        Util.doPostCallProcessing(this.userAgent, callDuration, this.calledTimeStamp, this.logger, this.userAgent.getMediaManager().getWavFileName());
    }

    @Override
    public void ringing(SipResponse sipResponse) {
        System.out.println("Ringing...");
    }

    public void register() {
        if (this.userAgent == null) {
            Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, this.logger, null);
            return;
        }
        Config config = this.userAgent.getConfig();
        if (config.getPassword() != null) {
            try {
                this.userAgent.register();
            }
            catch (SipUriSyntaxException e) {
                System.out.println(e.getMessage());
                Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, this.logger, null);
            }
        }
    }

    private void makeACall() {
        String uri = String.format("sip:%s@%s", Container.bonrixConfig.numberToBeCalled, this.userAgent.getConfig().getDomain());
        String callId = Utils.generateCallID(this.userAgent.getConfig().getLocalInetAddress());
        try {
            this.sipRequest = this.userAgent.invite(uri, callId);
            this.calledTimeStamp = new Date();
        }
        catch (SipUriSyntaxException e) {
            this.logger.error(e.getMessage(), e);
            Util.doPostCallProcessing(this.userAgent, 0, this.calledTimeStamp, this.logger, null);
        }
    }

    private void disconnectCallApiAndExit() {
        this.userAgent.terminate(this.sipRequest);
        this.callDisconnectTimeStamp = new Date();
        int callDuration = (int)((this.callDisconnectTimeStamp.getTime() - this.callPickTimeStamp.getTime()) / 1000L);
        Util.doPostCallProcessing(this.userAgent, callDuration, this.calledTimeStamp, this.logger, this.userAgent.getMediaManager().getWavFileName());
    }
}

